package w83b.w83bDAO;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.naming.NamingException;

import org.apache.commons.lang.StringUtils;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bCierreMensualBean;
import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bTramiteActaBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCierreBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bResultadosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;


public class W83bCierreDAO implements W83bICierreDAO {
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bICierreDAO#buscarInicioCierre(w83b.w83bBeans.W83bCierreMensualBean)
	 */
	int nELA=0;
	int nLAB=0;
	int nUGT=0;
	int nCCOO=0;
	int nOtros=0;
	int nUSO=0;
	int nCUIS=0;
	int nCTI=0;
	int nCSI=0;
	int nNOSIN=0;
	int numdelegadosELA=0;
    int numdelegadosLAB=0;
    int numdelegadosUGT=0;
    int numdelegadosCCOO=0;
    int numdelegadosOtros=0;
    int numdelegadosUSO=0;
    int numdelegadosCUIS=0;
    int numdelegadosCTI=0;
    int numdelegadosCSI=0;
    int numdelegadosNOSIN=0;
    int numdelegadosELAdes=0;
    int numdelegadosLABdes=0;
    int numdelegadosUGTdes=0;
    int numdelegadosCCOOdes=0;
    int numdelegadosOtrosdes=0;
    int numdelegadosUSOdes=0;
    int numdelegadosCUISdes=0;
    int numdelegadosCTIdes=0;
    int numdelegadosCSIdes=0;
    int numdelegadosNOSINdes=0;
    int nELAdes=0;
    int nLABdes=0;
    int nUGTdes=0;
    int nCCOOdes=0;
    int nOtrosdes=0;
    int nUSOdes=0;
    int nCUISdes=0;
    int nCTIdes=0;
    int nCSIdes=0;
    int nNOSINdes=0;
    
	public java.util.List buscarInicioCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bCierreBD.anocierre).append(", ");
		strSql.append(W83bCierreBD.mescierre);
		strSql.append(" FROM ").append(W83bCierreBD.tablacierre);
		strSql.append(" WHERE ");
		if(W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierrealava).append("='S'");
		}
		if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.cierrebizkaia).append("='S'");
				
		}
		if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierregipuzkoa).append("='S'");
		}
		strSql.append(" ORDER BY ");
		strSql.append(W83bCierreBD.anocierre).append(" DESC, ");
		strSql.append(W83bCierreBD.mescierre).append(" DESC");
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bCierreMensualBean.class,param.getUsuarioBean(), null);
		W83bCierreMensualBean cm=new W83bCierreMensualBean();
		List l=new ArrayList();
		int ano;
		int mes;
		if (Integer.parseInt(((W83bCierreMensualBean)lista.get(0)).getMescierre())==12){
			ano=Integer.parseInt(((W83bCierreMensualBean)lista.get(0)).getAnocierre())+1;
			mes=1;
		}
		else{
			ano=Integer.parseInt(((W83bCierreMensualBean)lista.get(0)).getAnocierre());
			mes=Integer.parseInt(((W83bCierreMensualBean)lista.get(0)).getMescierre())+1;
		}
		cm.setAnocierre(String.valueOf(ano));
		cm.setMes(String.valueOf(mes));
		cm.setMescierre(W83bDateUtil.getInstance().sabernombremes(mes-1,param.getIdioma()));
		String DATE_FORMAT;
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			DATE_FORMAT = "dd/MM/yyyy";
		}
		else{
			DATE_FORMAT = "yyyy/MM/dd";
		}
		
		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
		Calendar c1 = Calendar.getInstance(); 
		c1.set(ano, mes-1 , 1);
		int dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(ano, mes-1 , dias);
		cm.setFechaeleccionhasta(sdf.format(c1.getTime()));
		c1.add(Calendar.DATE,1);
		c1.add(Calendar.YEAR,-4);
		cm.setFechaelecciondesde(sdf.format(c1.getTime()));
		
		c1.set(ano, mes , 1);
		dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(ano, mes , dias);
		cm.setFecharegistrohasta(sdf.format(c1.getTime()));
		cm.setTerritorio(param.getTerritorio());
		cm.setPerfil(param.getPerfil());
		cm.setDeshacercierre(param.getDeshacercierre());
		cm.setMesanterior(param.getMesanterior());
		l.add(0, cm);
		
		return l;		
	}
	
/*	public String fechaUltimoCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String resultado="sintramitar";
		strSql.append("SELECT "); 
		strSql.append("MAX(");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(")");
		strSql.append(" FROM ").append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(" =? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(" =? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(" =? ");
		params.add(param.getTerritorio());
		params.add(W83bClsConstantes.FASE_CIERRE_MENSUAL);
		params.add(W83bClsConstantes.TRAMITE_CIERRE_MENSUAL);
		W83bClsTrazas.trazaError(null, "strSql="+strSql, null);
		W83bClsTrazas.trazaError(null, "params="+params, null);
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "lista.size()="+lista.size(), null);
		if (String.valueOf(lista.get(0))!="null"&&String.valueOf(lista.get(0))!=null&&!"".equals(String.valueOf(lista.get(0)))){
			resultado=String.valueOf(lista.get(0));
		}
		W83bClsTrazas.trazaError(null, "resultado="+resultado, null);
		return resultado;		
	}*/
	
	public String fechaUltimoCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String resultado="sintramitar";
		strSql.append("SELECT MAX(");
		if (W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.fechacierreAraba);
		}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.fechacierreBizkaia);
		}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.fechacierreGipuzkoa);
		}

		strSql.append(") FROM ").append(W83bCierreBD.tablacierre);

		W83bClsTrazas.trazaError(null, "strSql="+strSql, null);
		W83bClsTrazas.trazaError(null, "params="+params, null);
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "lista.size()="+lista.size(), null);
		if (String.valueOf(lista.get(0))!="null"&&String.valueOf(lista.get(0))!=null&&!"".equals(String.valueOf(lista.get(0)))){
			resultado=String.valueOf(lista.get(0));
		}
		W83bClsTrazas.trazaError(null, "resultado="+resultado, null);
		return resultado;		
	}
	
	public java.util.List calculoFila1(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		List l=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.anoacta).append(", ");
		strSql.append(W83bResultadosBD.ver).append(", ");
		strSql.append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.siglas).append(", ");
		strSql.append(W83bResultadosBD.sinddesc).append(", ");
		strSql.append(W83bResultadosBD.tipoconvenio).append(", ");
		strSql.append(W83bResultadosBD.numdelegados).append(", ");
		strSql.append(W83bResultadosBD.territ).append(", ");
		strSql.append(W83bResultadosBD.nregdef).append(", ");
		strSql.append(W83bResultadosBD.anoregdef).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bResultadosBD.felec);
		strSql.append(",?)");
		strSql.append(" AS ").append(W83bResultadosBD.felec).append(", ");
		strSql.append(W83bResultadosBD.cif).append(", ");
		strSql.append(W83bResultadosBD.razon).append(", ");
		strSql.append(W83bResultadosBD.ncentro);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bResultadosBD.vistaDatosPrecierre);
	    strSql.append("(?,?,?,?,?,?,?))");
	    //AADIDO LO DE EL MAX VERSIN X JAVI
	    //PARA ADECUARNOS A LOS CAMBIOS EN 
	    //EL RESUMEN DE RESULTADOS
	    String DATE_FORMAT = "dd/MM/yyyy";
	    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
	    Calendar c1 = Calendar.getInstance();
	    Calendar c2 = Calendar.getInstance();
	    Calendar c3 = Calendar.getInstance();
	    
	    strSql.append(" dc, ");
		strSql.append(" (SELECT MAX (").append(W83bResultadosBD.VERSION_016).append(" ) AS maxver, ");
		strSql.append(W83bResultadosBD.N_ACTA_016).append(",").append(W83bResultadosBD.ANO_ACTA_016).append(",");
		strSql.append(W83bResultadosBD.C_TERRIT_016).append(" FROM ").append(W83bResultadosBD.tabla16);
		strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
			strSql.append(W83bResultadosBD.C_TERRIT_016).append("=").append("? ");
		}
		
		strSql.append(" AND (");
		strSql.append(W83bResultadosBD.F_BAJA_016).append(" IS NULL ");
		
				
				strSql.append(" OR ");
				strSql.append(W83bResultadosBD.F_BAJA_016).append(">").append("TO_DATE(?,'dd/MM/yyyy') ");
				
		strSql.append(" )");

		String[] arrayfecha2 = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c3.set(Integer.parseInt(arrayfecha2[2]), Integer.parseInt(arrayfecha2[1])-2 , 1);
		int dias2=c3.getActualMaximum(Calendar.DAY_OF_MONTH);
		c3.set(Integer.parseInt(arrayfecha2[2]), Integer.parseInt(arrayfecha2[1])-2 , dias2);
		
		strSql.append(" AND (").append(W83bResultadosBD.factu_016).append("<=TO_DATE('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(sdf.format(c3.getTime()),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss')");
		strSql.append(" OR ").append(W83bResultadosBD.factu_016).append(" IS NULL )");
		strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1");
		strSql.append(" GROUP BY ").append(W83bResultadosBD.N_ACTA_016).append(",");
		strSql.append(W83bResultadosBD.ANO_ACTA_016).append(",").append(W83bResultadosBD.C_TERRIT_016).append(" ) maxresults ");
		
		strSql.append(" where DC.").append(W83bResultadosBD.nacta).append("=").append("maxresults.").append(W83bResultadosBD.N_ACTA_016);
		strSql.append(" AND ");
		strSql.append("DC.").append(W83bResultadosBD.anoacta).append("=").append("maxresults.").append(W83bResultadosBD.ANO_ACTA_016);
		strSql.append(" AND ");
		strSql.append("DC.").append(W83bResultadosBD.territ).append("=").append("maxresults.").append(W83bResultadosBD.C_TERRIT_016);
		strSql.append(" AND ");
		strSql.append("DC.").append(W83bResultadosBD.ver).append("=").append("maxresults.maxver");
	    
	    
	    
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    
		
		String[] arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		params.add(sdf.format(c1.getTime()));
		
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		
		c2.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		int dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , dias);
		c2.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , dias);
		params.add(sdf.format(c1.getTime()));
		
		
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , dias);
		params.add(sdf.format(c1.getTime()));
		
		params.add(param.getTerritorio());
	    params.add("todos");
	    //params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    //aadido por Ana para volver a probar el cierre
	    params.add(sdf.format(c1.getTime()));
	    params.add("nohay");
	    
				params.add(param.getTerritorio());
				params.add(sdf.format(c2.getTime()));
	    
	    List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), null);
	    l.add(lista);
	    
	    inicializarVariablesDelegados();
	    W83bCierreMensualBean cm = new W83bCierreMensualBean();
	    String nacta="";
		String territ="";
		String anoacta="";
		int maxversion=0;
		for (int i=0;i<lista.size();i++){
			W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
			if (i==0
					||(nacta.equals(res.getNacta())&&territ.equals(res.getTerritorio())&&anoacta.equals(res.getAnoacta())&&maxversion==Integer.parseInt(res.getVer()))
					||(!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta()))){
				if (res.getCodsindicato()!=null){
					sumardelegados(res.getCodsindicato(),res.getNumdelegados());
				}
			}
			if (!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta())){
				maxversion=Integer.parseInt(res.getVer());
			}
			nacta=res.getNacta();
			territ=res.getTerritorio();
			anoacta=res.getAnoacta();
	    }
		
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , dias);
		
	    cm.setTexto(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.litcierre",param.getIdioma(),null)+" "+sdf.format(c1.getTime()));
	    cm=obtenerObjetoCierre(cm);
	    l.add(cm);
	    return l;
	}
	
	public java.util.List calculoFila2(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		List l=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.numdelegados).append(", ");;
		strSql.append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.anoacta).append(", ");
		strSql.append(W83bResultadosBD.territ).append(", ");
		strSql.append(W83bResultadosBD.ver).append(", ");
		strSql.append(W83bResultadosBD.nregdef).append(", ");
		strSql.append(W83bResultadosBD.anoregdef).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bResultadosBD.felec);
		strSql.append(",?)");
		strSql.append(" AS ").append(W83bResultadosBD.felec).append(", ");
		strSql.append(W83bResultadosBD.cif).append(", ");
		strSql.append(W83bResultadosBD.razon).append(", ");
		strSql.append(W83bResultadosBD.ncentro);
		strSql.append(" FROM ").append(W83bResultadosBD.vistaResCenSindInc);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bResultadosBD.territ).append("=").append("? ");
		params.add(param.getTerritorio());
		
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		
		String DATE_FORMAT = "dd/MM/yyyy";
		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
		Calendar c1 = Calendar.getInstance(); 
		String[] arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		params.add(sdf.format(c1.getTime()));
		
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		c1 = Calendar.getInstance(); 
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		int dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , dias);
		params.add(sdf.format(c1.getTime()));
		
		strSql.append(" AND ("); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
		strSql.append(" OR ("); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
		strSql.append(" AND ");  
		;  
		strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')))");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		params.add(sdf.format(c1.getTime()));
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), null);
		l.add(lista);
		
		inicializarVariablesDelegados();
	    W83bCierreMensualBean cm = new W83bCierreMensualBean();
	    
		cm=new W83bCierreMensualBean();
		for (int i=0;i<lista.size();i++){
	    	W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
	    	if (res.getCodsindicato()!=null){
	    		sumardelegados(res.getCodsindicato(),res.getNumdelegados());
	    	}
	    }
		cm.setTexto(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.caen",param.getIdioma(),null)+"("+W83bUtilidades.rellenarCaracter(String.valueOf((Integer.parseInt(arrayfecha[1]))), "0", 2, true)+"/"+String.valueOf((Integer.parseInt(arrayfecha[2])-4))+")");
		if (numdelegadosELA!=0){
			numdelegadosELA=-numdelegadosELA;
		}
		if (numdelegadosLAB!=0){
			numdelegadosLAB=-numdelegadosLAB;
		}
		if (numdelegadosUGT!=0){
			numdelegadosUGT=-numdelegadosUGT;
		}
		if (numdelegadosCCOO!=0){
			numdelegadosCCOO=-numdelegadosCCOO;
		}
		if (numdelegadosOtros!=0){
			numdelegadosOtros=-numdelegadosOtros;
		}
		if (numdelegadosUSO!=0){
			numdelegadosUSO=-numdelegadosUSO;
		}
		if (numdelegadosCUIS!=0){
			numdelegadosCUIS=-numdelegadosCUIS;
		}
		if (numdelegadosCTI!=0){
			numdelegadosCTI=-numdelegadosCTI;
		}
		if (numdelegadosCSI!=0){
			numdelegadosCSI=-numdelegadosCSI;
		}
		if (numdelegadosNOSIN!=0){
			numdelegadosNOSIN=-numdelegadosNOSIN;
		}
		cm=obtenerObjetoCierre(cm);
	    
	    l.add(cm);
	    
	    return l;
	}
	
	public java.util.List bajascierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		List l=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.numdelegados).append(", ");;
		strSql.append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.anoacta).append(", ");
		strSql.append(W83bResultadosBD.territ).append(", ");
		strSql.append(W83bResultadosBD.ver).append(", ");
		strSql.append(W83bResultadosBD.nregdef).append(", ");
		strSql.append(W83bResultadosBD.anoregdef).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bResultadosBD.felec);
		strSql.append(",?)");
		strSql.append(" AS ").append(W83bResultadosBD.felec).append(", ");
		strSql.append(W83bResultadosBD.cif).append(", ");
		strSql.append(W83bResultadosBD.razon).append(", ");
		strSql.append(W83bResultadosBD.ncentro);
		strSql.append(" FROM ").append(W83bResultadosBD.vistaResCenSindInc);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bResultadosBD.territ).append("=").append("? ");
		params.add(param.getTerritorio());
		
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		
		String DATE_FORMAT = "dd/MM/yyyy";
		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
		Calendar c1 = Calendar.getInstance(); 
		
		String[] arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		params.add(sdf.format(c1.getTime()));
		strSql.append(" AND "); 
		strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		int dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , dias);
		params.add(sdf.format(c1.getTime()));
		
		strSql.append(" AND ("); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
		strSql.append(" AND ");  
		strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		params.add(sdf.format(c1.getTime()));
		strSql.append(" AND ");  
		strSql.append(W83bResultadosBD.fechabaja).append(" <= ").append("TO_DATE(?, 'dd/MM/yyyy'))");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , dias);
		params.add(sdf.format(c1.getTime()));
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), null);
		l.add(lista);
		
		inicializarVariablesDelegados();
	    W83bCierreMensualBean cm = new W83bCierreMensualBean();
	    
		cm=new W83bCierreMensualBean();
		for (int i=0;i<lista.size();i++){
	    	W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
	    	if (res.getCodsindicato()!=null){
	    		sumardelegados(res.getCodsindicato(),res.getNumdelegados());
	    	}
	    }
		cm.setTexto(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.bajas",param.getIdioma(),null)+"("+W83bUtilidades.rellenarCaracter(String.valueOf((Integer.parseInt(arrayfecha[1]))), "0", 2, true)+"/"+arrayfecha[2]+")");
		if (numdelegadosELA!=0){
			numdelegadosELA=-numdelegadosELA;
		}
		if (numdelegadosLAB!=0){
			numdelegadosLAB=-numdelegadosLAB;
		}
		if (numdelegadosUGT!=0){
			numdelegadosUGT=-numdelegadosUGT;
		}
		if (numdelegadosCCOO!=0){
			numdelegadosCCOO=-numdelegadosCCOO;
		}
		if (numdelegadosOtros!=0){
			numdelegadosOtros=-numdelegadosOtros;
		}
		if (numdelegadosUSO!=0){
			numdelegadosUSO=-numdelegadosUSO;
		}
		if (numdelegadosCUIS!=0){
			numdelegadosCUIS=-numdelegadosCUIS;
		}
		if (numdelegadosCTI!=0){
			numdelegadosCTI=-numdelegadosCTI;
		}
		if (numdelegadosCSI!=0){
			numdelegadosCSI=-numdelegadosCSI;
		}
		if (numdelegadosNOSIN!=0){
			numdelegadosNOSIN=-numdelegadosNOSIN;
		}
		cm=obtenerObjetoCierre(cm);
	    
	    l.add(cm);
	    
	    return l;
	}
	
	public java.util.List calculoFila3(w83b.w83bBeans.W83bCierreMensualBean param, List calculo, List ultimafila) throws Exception{
		W83bClsTrazas.trazaError(null, "calculoFila3=", null);
		List l=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
	  
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.numdelegados).append(", ");
		strSql.append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.anoacta).append(", ");
		strSql.append(W83bResultadosBD.territ).append(", ");
		strSql.append(W83bResultadosBD.ver).append(", ");
		strSql.append(W83bResultadosBD.nregdef).append(", ");
		strSql.append(W83bResultadosBD.anoregdef).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bResultadosBD.felec);
		strSql.append(",?)");
		strSql.append(" AS ").append(W83bResultadosBD.felec).append(", ");
		strSql.append(W83bResultadosBD.cif).append(", ");
		strSql.append(W83bResultadosBD.razon).append(", ");
		strSql.append(W83bResultadosBD.ncentro);
		strSql.append(" FROM ").append(W83bResultadosBD.vistaResDelegInc);
		strSql.append(" deleg WHERE deleg.");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bResultadosBD.territ).append("=").append("? ");
		params.add(param.getTerritorio());
		
		strSql.append(" AND deleg.");
		strSql.append(W83bResultadosBD.fechavalidacion).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		String DATE_FORMAT = "dd/MM/yyyy";
		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
		Calendar c1 = Calendar.getInstance(); 
		String[] arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		params.add(sdf.format(c1.getTime()));
		
		strSql.append(" AND deleg.");
		strSql.append(W83bResultadosBD.fechavalidacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		
		strSql.append(" AND deleg."); 
		strSql.append(W83bResultadosBD.fechaincidencia).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND deleg.");
		strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		params.add(sdf.format(c1.getTime()));
		
		strSql.append(" AND deleg.");
		strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND (deleg."); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
		strSql.append(" OR (deleg."); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
		strSql.append(" AND deleg.");  
		strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')))");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND deleg."); 
		strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		/**/
		strSql.append(" AND (deleg."); 
		strSql.append(W83bResultadosBD.nacta).append(", deleg.");
		strSql.append(W83bResultadosBD.anoacta).append(", deleg.");
		strSql.append(W83bResultadosBD.territ).append(") in (");
		strSql.append("SELECT delegTemp."); 
		strSql.append(W83bResultadosBD.nacta).append(", delegTemp.");
		strSql.append(W83bResultadosBD.anoacta).append(", delegTemp.");
		strSql.append(W83bResultadosBD.territ);
		strSql.append(" FROM ").append(W83bResultadosBD.vistaDatosInc);
		strSql.append(" delegTemp WHERE ");
		
		strSql.append(" deleg.");
		strSql.append(W83bResultadosBD.nacta).append(" = delegTemp.");
		strSql.append(W83bResultadosBD.nacta).append(" and  ");
		strSql.append(" deleg.");
		strSql.append(W83bResultadosBD.anoacta).append(" = delegTemp.");
		strSql.append(W83bResultadosBD.anoacta).append(" and  ");
		strSql.append(" deleg.");
		strSql.append(W83bResultadosBD.territ).append(" = delegTemp.");
		strSql.append(W83bResultadosBD.territ);
		
		strSql.append(" AND delegTemp.");
		strSql.append(W83bResultadosBD.fechavalidacion).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		String DATE_FORMAT2 = "dd/MM/yyyy";
		java.text.SimpleDateFormat sdf2 = new java.text.SimpleDateFormat(DATE_FORMAT2);
		Calendar c12 = Calendar.getInstance(); 
		String[] arrayfecha2 = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c12.set(Integer.parseInt(arrayfecha2[2]), Integer.parseInt(arrayfecha2[1])-1 , 1);
		params.add(sdf2.format(c12.getTime()));
		
		strSql.append(" AND delegTemp.");
		strSql.append(W83bResultadosBD.fechavalidacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		
		strSql.append(" AND delegTemp."); 
		strSql.append(W83bResultadosBD.fechaincidencia).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND delegTemp.");
		strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-2 , 1);
		params.add(sdf.format(c1.getTime()));
		
		strSql.append(" AND delegTemp.");
		strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND (delegTemp."); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
		strSql.append(" OR (delegTemp."); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
		strSql.append(" AND delegTemp.");  
		strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')))");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND delegTemp."); 
		strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		strSql.append(" AND delegTemp."); 
		strSql.append(W83bResultadosBD.ver).append(" = (");
		strSql.append("SELECT max(delegVer."); 
		strSql.append(W83bResultadosBD.ver);
		strSql.append(") FROM ").append(W83bResultadosBD.vistaDatosInc);
		strSql.append(" delegVer WHERE ");
		
		strSql.append(" delegVer.");
		strSql.append(W83bResultadosBD.nacta).append(" = delegTemp.");
		strSql.append(W83bResultadosBD.nacta).append(" and  ");
		strSql.append(" delegVer.");
		strSql.append(W83bResultadosBD.anoacta).append(" = delegTemp.");
		strSql.append(W83bResultadosBD.anoacta).append(" and  ");
		strSql.append(" delegVer.");
		strSql.append(W83bResultadosBD.territ).append(" = delegTemp.");
		strSql.append(W83bResultadosBD.territ);
		
		strSql.append(" AND delegVer.");
		strSql.append(W83bResultadosBD.fechavalidacion).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		DATE_FORMAT2 = "dd/MM/yyyy";
		sdf2 = new java.text.SimpleDateFormat(DATE_FORMAT2);
		c12 = Calendar.getInstance(); 
		arrayfecha2 = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c12.set(Integer.parseInt(arrayfecha2[2]), Integer.parseInt(arrayfecha2[1])-1 , 1);
		params.add(sdf2.format(c12.getTime()));
		
		strSql.append(" AND delegVer.");
		strSql.append(W83bResultadosBD.fechavalidacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		
		
		strSql.append(" AND delegVer."); 
		strSql.append(W83bResultadosBD.fechaincidencia).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		strSql.append(")) "); 
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), null);
		l.add(lista);
		inicializarVariablesDelegados();
	    W83bCierreMensualBean cm = new W83bCierreMensualBean();
		String nacta="";
		String territ="";
		String anoacta="";
		int maxversion=0;
		
		//Cogemos las incidencias de la ltima versin
		HashMap actas=new HashMap();
		HashMap sindicatos=new HashMap();
		HashMap datosactamap=new HashMap();
		int nd=0;
		for (int j=0;j<calculo.size();j++){
			W83bResultadosBean rescalculo = (W83bResultadosBean)calculo.get(j);
			if (j==0
					||(nacta.equals(rescalculo.getNacta())&&territ.equals(rescalculo.getTerritorio())&&anoacta.equals(rescalculo.getAnoacta())&&maxversion==Integer.parseInt(rescalculo.getVer()))
					||(!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta()))){
				if ((!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta()))){
					sindicatos=(HashMap)actas.get(territ+"|"+anoacta+"|"+nacta);
					if (sindicatos!=null){
						if (sindicatos.keySet().contains(null)&&sindicatos.size()>1){
							sindicatos.remove(null);
						}
					}
					sindicatos=new HashMap();//NOPMD
				}
				if (sindicatos.get(rescalculo.getCodsindicato())!=null){
					nd=Integer.parseInt(String.valueOf(sindicatos.get(rescalculo.getCodsindicato())));
					sindicatos.put(rescalculo.getCodsindicato(),String.valueOf(nd+Integer.parseInt(rescalculo.getNumdelegados())));
				}
				else{
					nd=0;
					sindicatos.put(rescalculo.getCodsindicato(),rescalculo.getNumdelegados());
				}
				actas.put(rescalculo.getTerritorio()+"|"+rescalculo.getAnoacta()+"|"+rescalculo.getNacta(),sindicatos);
			}
			if (!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta())){
				maxversion=Integer.parseInt(rescalculo.getVer());
			}
			nacta=rescalculo.getNacta();
			territ=rescalculo.getTerritorio();
			anoacta=rescalculo.getAnoacta();
			if (j==lista.size()-1){
				sindicatos=(HashMap)actas.get(territ+"|"+anoacta+"|"+nacta);
				if (sindicatos!=null){
					if (sindicatos.keySet().contains(null)&&sindicatos.size()>1){
						sindicatos.remove(null);
					}
				}
			}
	    }
		nacta="";
		territ="";
		anoacta="";
		maxversion=0;
		HashMap incidencias=new HashMap();
		sindicatos=new HashMap();
		nd=0;
		for (int j=0;j<lista.size();j++){
			W83bResultadosBean rescalculo = (W83bResultadosBean)lista.get(j);
			if (j==0||
					(nacta.equals(rescalculo.getNacta())&&territ.equals(rescalculo.getTerritorio())&&anoacta.equals(rescalculo.getAnoacta())&&maxversion==Integer.parseInt(rescalculo.getVer()))||
					(!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta()))){
				
				if ((!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta()))){
					sindicatos=(HashMap)incidencias.get(territ+"|"+anoacta+"|"+nacta);
					if (sindicatos!=null){
						if (sindicatos.keySet().contains(null)&&sindicatos.size()>1){
							sindicatos.remove(null);
						}
					}
					sindicatos=new HashMap();//NOPMD
				}
				if (sindicatos.get(rescalculo.getCodsindicato())!=null){
					nd=Integer.parseInt(String.valueOf(sindicatos.get(rescalculo.getCodsindicato())));
					sindicatos.put(rescalculo.getCodsindicato(),String.valueOf(nd+Integer.parseInt(rescalculo.getNumdelegados())));
				}
				else{
					nd=0;
					sindicatos.put(rescalculo.getCodsindicato(),rescalculo.getNumdelegados());
				}
				sindicatos.put(rescalculo.getCodsindicato(),rescalculo.getNumdelegados());
				incidencias.put(rescalculo.getTerritorio()+"|"+rescalculo.getAnoacta()+"|"+rescalculo.getNacta(),sindicatos);
				datosactamap.put(rescalculo.getTerritorio()+"|"+rescalculo.getAnoacta()+"|"+rescalculo.getNacta(),rescalculo.getNregdef()+"|"+rescalculo.getAnoregdef()+"|"+rescalculo.getFelec()+"|"+rescalculo.getCif()+"|"+rescalculo.getRazon()+"|"+rescalculo.getNcentro());
			}
			if (!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta())){
				maxversion=Integer.parseInt(rescalculo.getVer());
			}
			nacta=rescalculo.getNacta();
			territ=rescalculo.getTerritorio();
			anoacta=rescalculo.getAnoacta();
			if (j==lista.size()-1){
				sindicatos=(HashMap)incidencias.get(territ+"|"+anoacta+"|"+nacta);
				if (sindicatos!=null){
					if (sindicatos.keySet().contains(null)&&sindicatos.size()>1){
						sindicatos.remove(null);
					}
				}
			}
	    }
		nd=0;
		HashMap ultfila=new HashMap();
		sindicatos=new HashMap();
		for (int j=0;j<ultimafila.size();j++){
			W83bResultadosBean rescalculo = (W83bResultadosBean)ultimafila.get(j);
			if ((!nacta.equals(rescalculo.getNacta())||!territ.equals(rescalculo.getTerritorio())||!anoacta.equals(rescalculo.getAnoacta()))){
				sindicatos=(HashMap)ultfila.get(territ+"|"+anoacta+"|"+nacta);
				if (sindicatos!=null){
					if (sindicatos.keySet().contains(null)&&sindicatos.size()>1){
						sindicatos.remove(null);
					}
				}
				sindicatos=new HashMap();//NOPMD
			}
			if (sindicatos.get(rescalculo.getCodsindicato())!=null){
				nd=Integer.parseInt(String.valueOf(sindicatos.get(rescalculo.getCodsindicato())));
				sindicatos.put(rescalculo.getCodsindicato(),String.valueOf(nd+Integer.parseInt(rescalculo.getNumdelegados())));
			}
			else{
				nd=0;
				sindicatos.put(rescalculo.getCodsindicato(),rescalculo.getNumdelegados());
			}
			ultfila.put(rescalculo.getTerritorio()+"|"+rescalculo.getAnoacta()+"|"+rescalculo.getNacta(),sindicatos);
			
			nacta=rescalculo.getNacta();
			territ=rescalculo.getTerritorio();
			anoacta=rescalculo.getAnoacta();
			if (j==lista.size()-1){
				sindicatos=(HashMap)ultfila.get(territ+"|"+anoacta+"|"+nacta);
				if (sindicatos!=null){
					if (sindicatos.keySet().contains(null)&&sindicatos.size()>1){
						sindicatos.remove(null);
					}
				}
			}
	    }
		HashMap sindicatosincidencias=new HashMap();
		HashMap sindicatosactas=new HashMap();
		Iterator itsindind;
		Iterator itsindact;
		Map.Entry sindind;
		HashMap excel=new HashMap();
		boolean consindind=false;
		Map.Entry sindact;
		
		inicializarVariablesDelegadosdes();
		//Si no tiene incidencias para el acta nueva
		W83bClsTrazas.trazaError(null, "incidenciaaaas="+incidencias.size(), null);
		W83bClsTrazas.trazaError(null, "incidencias="+incidencias.size(), null);
		W83bClsTrazas.trazaError(null, "ultfila="+ultfila.size(), null);
		Iterator uf = ultfila.entrySet().iterator();
		HashMap excelultfila=new HashMap();
		while (uf.hasNext()){
			W83bClsTrazas.trazaError(null, "Entrado porque tiene en ultfila", null);
			Map.Entry e = (Map.Entry)uf.next();
			W83bClsTrazas.trazaError(null, "Miro si tiene incidencias ese acta="+e.getKey(), null);
			if ((HashMap)incidencias.get(e.getKey())==null){
				W83bClsTrazas.trazaError(null, "No tiene, entrado en if", null);
				String actanueva = (String)e.getKey();
				excelultfila=calculardelegadossinuevasnoincidencias(excelultfila,actanueva, W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO), param.getUsuarioBean());
			}
		}
		
		
			Iterator it = incidencias.entrySet().iterator();
			while (it.hasNext()) {
				inicializarVariablesSindicato();
				Map.Entry e = (Map.Entry)it.next();
				sindicatosincidencias=(HashMap)e.getValue();
				sindicatosactas=(HashMap)actas.get(e.getKey());
				
				if (sindicatosactas!=null){
					
					itsindind = sindicatosincidencias.entrySet().iterator();
					itsindact = sindicatosactas.entrySet().iterator();
					while (itsindind.hasNext()) {
						consindind=false;
						sindind = (Map.Entry)itsindind.next();
						if (sindind.getKey()!=null){
							consindind=true;
							if (sindicatosactas.get(sindind.getKey())!=null){
								sumarsindcoincidentes((String)sindind.getKey(),(String)sindind.getValue(),(String)sindicatosactas.get(sindind.getKey()));
							}
							else{
								sumardelegados((String)sindind.getKey(),(String)sindind.getValue());
								sumardelegadosexcel((String)sindind.getKey(),(String)sindind.getValue());
							}
						}
						else{
							while (itsindact.hasNext()) {
								sindact = (Map.Entry)itsindact.next();
								if (sindact.getKey()!=null){
									restardelegados((String)sindact.getKey(),(String)sindact.getValue());
								}
							}
						}
					}
					//Cuando hay incidencias y hay sindicatos en actas que no estn en incidencias, se ha hecho una baja
					if (consindind){
						while (itsindact.hasNext()) {
							sindact = (Map.Entry)itsindact.next();
							if (sindact.getKey()!=null){
								if (sindicatosincidencias.get(sindact.getKey())==null){
									restardelegados((String)sindact.getKey(),(String)sindact.getValue());
								}
							}
						}
					}
				}
				else{
					//Si est el nmero de acta en la ltima fila
					if ((HashMap)ultfila.get(e.getKey())!=null){
						itsindind = sindicatosincidencias.entrySet().iterator();
						//Itero el array de sindicatos del map de incidencias con clave x
						while (itsindind.hasNext()) {
							consindind=false;
							//Sindicatos de la ltima fila con clave x
							sindicatos=(HashMap)ultfila.get(e.getKey());
							//Itero el array
							itsindact = sindicatos.entrySet().iterator();
							//Siguiente de sindicatos del map de actas
							sindind = (Map.Entry)itsindind.next();
							//Si es diferente de nulo
							//sindind, primer sindicato y sus delegados, Ejemplo-->3=1
							//Si 3 es diferente de nulo
							if (sindind.getKey()!=null){
								consindind=true;
								if (sindicatos.get(sindind.getKey())!=null){
									sumarsindcoincidentes((String)sindind.getKey(),(String)sindind.getValue(),(String)sindicatos.get(sindind.getKey()));
								}
								else{
									sumardelegados((String)sindind.getKey(),(String)sindind.getValue());
									sumardelegadosexcel((String)sindind.getKey(),(String)sindind.getValue());
								}
							}
							//Si la clave del map de actas es nulo
							else{
								//ltima fila
								while (itsindact.hasNext()) {
									sindact = (Map.Entry)itsindact.next();
									if (sindact.getKey()!=null){
										restardelegados((String)sindact.getKey(),(String)sindact.getValue());
									}
								}
							}
			
					}
						if (consindind){
							itsindact = sindicatos.entrySet().iterator();
							while (itsindact.hasNext()) {
								sindact = (Map.Entry)itsindact.next();
								if (sindact.getKey()!=null){
									if (sindicatosincidencias.get(sindact.getKey())==null){
										restardelegados((String)sindact.getKey(),(String)sindact.getValue());
									}
								}
							}
					}
				}
					
				//AADIDO POR JAVI Y COMENTADO
				/*else{

						itsindind = sindicatosincidencias.entrySet().iterator();
						//Itero el array de sindicatos del map de incidencias con clave x
						while (itsindind.hasNext()) {
							consindind=false;
							//Siguiente de sindicatos del map de actas
							sindind = (Map.Entry)itsindind.next();
							//Si es diferente de nulo
								sumardelegados((String)sindind.getKey(),(String)sindind.getValue());
								sumardelegadosexcel((String)sindind.getKey(),(String)sindind.getValue());
							}
							
			
					
				
				}*/
			 }
			String[] v=((String)e.getKey()).split("\\|");
			String[] valores=((String)datosactamap.get(e.getKey())).split("\\|");
			
			List datosacta=new ArrayList();//NOPMD
			datosacta.add(valores[0]);
			datosacta.add(valores[1]);
			datosacta.add(valores[2]);
			datosacta.add(valores[3]);
			datosacta.add(valores[4]);
			datosacta.add(valores[5]);
			datosacta.add(String.valueOf(nELA));
			datosacta.add(String.valueOf(nLAB));
			datosacta.add(String.valueOf(nUGT));
			datosacta.add(String.valueOf(nCCOO));
			datosacta.add(String.valueOf(nUSO));
			datosacta.add(String.valueOf(nCUIS));
			datosacta.add(String.valueOf(nCTI));
		    datosacta.add(String.valueOf(nCSI));
		    datosacta.add(String.valueOf(nNOSIN));
			datosacta.add(String.valueOf(nOtros));
					
			excel.put(v[0]+v[1]+W83bUtilidades.rellenarCaracter(v[2], "0", 6, true),datosacta);
			}
		cm.setTexto(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.inicidencias",param.getIdioma(),null));
		cm=obtenerObjetoCierre(cm);
	    l.add(cm);
	    l.add(excel);
	    l.add(excelultfila);
	    return l;
	}
	
	
	public java.util.List calculoFila4(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		List l=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ").append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.numdelegados).append(", ").append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.anoacta).append(", ");
		strSql.append(W83bResultadosBD.territ).append(", ");
		strSql.append(W83bResultadosBD.ver).append(", ").append(W83bResultadosBD.nregdef).append(", ");
		strSql.append(W83bResultadosBD.anoregdef).append(", ");
		strSql.append("TO_CHAR(").append(W83bResultadosBD.felec);
		strSql.append(",?)").append(" AS ").append(W83bResultadosBD.felec).append(", ");
		strSql.append(W83bResultadosBD.cif).append(", ");
		strSql.append(W83bResultadosBD.razon).append(", ");
		strSql.append(W83bResultadosBD.ncentro).append(", ");
		strSql.append(W83bResultadosBD.nueva);
		strSql.append(" FROM ").append(W83bResultadosBD.vistaResultadodelegcerrar);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bResultadosBD.territ).append("=").append("? ");
		params.add(param.getTerritorio());
		
		strSql.append(" AND "); 
		strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?, 'dd/MM/yyyy')");
		String DATE_FORMAT = "dd/MM/yyyy";
		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
		Calendar c1 = Calendar.getInstance(); 
		
		String[] arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaelecciondesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		params.add(sdf.format(c1.getTime()));
		strSql.append(" AND "); 
		strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		int dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , dias);
		params.add(sdf.format(c1.getTime()));
		strSql.append(" AND ("); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
		strSql.append(" OR ("); 
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
		strSql.append(" AND ");  
		strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')))");
		String fb=W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO);
		//Antes se miraban las actas nuevas este mes y 
		//dadas de baja (o no), el ltimo da del mes a cerrar.
		//Ahora se miran las actas nuevas este mes y la fecha de baja
		//principios de este mes (o nula).
		String[] arrayfecha2 = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(fb,param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		Calendar c2 = Calendar.getInstance(); 
		c2.set(Integer.parseInt(arrayfecha2[2]), Integer.parseInt(arrayfecha2[1])-1 , 1);
		params.add(sdf.format(c2.getTime()));
		strSql.append(" AND "); 
		strSql.append(W83bResultadosBD.fecharegistro).append(">=").append("TO_DATE(?, 'dd/MM/yyyy')");
		strSql.append(" AND "); 
		strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?, 'dd/MM/yyyy')");
		
		 strSql.append(" and ver = (SELECT MAX (");
		    strSql.append(W83bActasBD.versionActa);
		    strSql.append(") FROM ");
		    strSql.append(W83bActasBD.actasTable);
		    strSql.append(" act WHERE ");
		    strSql.append(W83bResultadosBD.nacta);
		    strSql.append(" = act.");
		    strSql.append(W83bActasBD.numActa);
		    strSql.append(" AND ");
		    strSql.append(W83bResultadosBD.anoacta);
		    strSql.append(" = act.");
		    strSql.append(W83bActasBD.anyoActa);
		    strSql.append(" AND ");
		    strSql.append(W83bResultadosBD.territ);
		    strSql.append(" = act.");
		    strSql.append(W83bActasBD.codTerritActa);
		    strSql.append(" AND act.");
		    strSql.append(W83bActasBD.validada);
		    strSql.append(" = 1)");
		
		arrayfecha=new String[3];
		arrayfecha = W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaeleccionhasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO).split("/");
		c1.set(Integer.parseInt(arrayfecha[2]), Integer.parseInt(arrayfecha[1])-1 , 1);
		params.add(sdf.format(c1.getTime()));
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecharegistrohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), null);
		
		l.add(lista);
		
		inicializarVariablesDelegados();
	    W83bCierreMensualBean cm = new W83bCierreMensualBean();
	    
		for (int i=0;i<lista.size();i++){
	    	W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
	    		if (res.getCodsindicato()!=null){
		    		sumardelegados(res.getCodsindicato(),res.getNumdelegados());
		    	}
	    	
	    }
		
	    cm=new W83bCierreMensualBean();
		cm.setTexto(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.nuevas",param.getIdioma(),null));
		cm=obtenerObjetoCierre(cm);
	    l.add(cm);
	   
		return l;		
	}
	
	public W83bCierreMensualBean calculoDeshacer(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		
		numdelegadosELA=param.getEla()+numdelegadosELAdes;
	    numdelegadosLAB=param.getLab()+numdelegadosLABdes;
	    numdelegadosUGT=param.getUgt()+numdelegadosUGTdes;
	    numdelegadosCCOO=param.getCcoo()+numdelegadosCCOOdes;
	    numdelegadosOtros=param.getOtros()+numdelegadosOtrosdes;
	    numdelegadosUSO=param.getUso()+numdelegadosUSOdes;
	    numdelegadosCUIS=param.getCuis()+numdelegadosCUISdes;
	    numdelegadosCTI=param.getCti()+numdelegadosCTIdes;
	    numdelegadosCSI=param.getCsi()+numdelegadosCSIdes;
	    numdelegadosNOSIN=param.getNosin()+numdelegadosNOSINdes;
	    
	    W83bCierreMensualBean cm=new W83bCierreMensualBean();
		cm.setTexto(param.getTexto());
		cm=obtenerObjetoCierre(cm);
	   
		return cm;		
	}
	
//	public String modificarcamponueva(List lista,w83b.w83bBeans.W83bCierreMensualBean param){
//		String nacta="";
//	    String anoacta="";
//	    String territ="";
//	    String ver="";
//	    
//	    StringBuffer nCierre = new StringBuffer();
//	    nCierre.append(param.getAnocierre());
//	    String mes = param.getMes();
//	    if(mes.length()==1){
//	    	nCierre.append("0").append(mes);
//	    }else{
//	    	nCierre.append(mes);
//	    }
//	    
//	    Integer intCierre = new Integer(nCierre.toString());
//	    
//		for (int i=0;i<lista.size();i++){
//	    	W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
//	    		if (!nacta.equals(res.getNacta())||!anoacta.equals(res.getAnoacta())||!territ.equals(res.getTerritorio())||!ver.equals(res.getVer())){
//	    			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
//	    			List params = new ArrayList();//NOPMD
//	    			strSql.append("UPDATE ");
//	    			strSql.append(W83bActasBD.tablaActas);
//	    			strSql.append(" SET ");
//	    			strSql.append(W83bActasBD.nueva).append("=?");
//	    			strSql.append(" WHERE ");
//	    			strSql.append(W83bActasBD.numActa).append("=?");
//	    			strSql.append(" AND ");
//	    			strSql.append(W83bActasBD.anyoActa).append("=?");
//	    			strSql.append(" AND ");
//	    			strSql.append(W83bActasBD.codTerritActa).append("=?");
////	    			strSql.append(" AND ");
////	    			strSql.append(W83bActasBD.versionActa).append("=?");
//	    			
//	    			
//	    			params.add(intCierre);
//	    			
//	    			params.add(res.getNacta());
//	    			params.add(res.getAnoacta());
//	    			params.add(res.getTerritorio());
////	    			params.add(res.getVer());
//	    			try {
//	    				W83bDataBase.executeTableMovement(strSql.toString(), params, null);
//	    			} catch (SQLException e) {
//	    				// TODO Auto-generated catch block
//	    				e.printStackTrace();
//	    			} catch (NamingException e) {
//	    				// TODO Auto-generated catch block
//	    				e.printStackTrace();
//	    			}
//	    			nacta=res.getNacta();
//	    			anoacta=res.getAnoacta();
//	    			territ=res.getTerritorio();
//	    			ver=res.getVer();
//	    		}
//	    }
//		return "0";
//	}
	
	public String modificarcamponueva(W83bResultadosBean res) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();//NOPMD
		strSql.append("UPDATE ");
		strSql.append(W83bActasBD.tablaActas);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.nueva).append("=1");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=?");
//		strSql.append(" AND ");
//		strSql.append(W83bActasBD.versionActa).append("=?");
		params.add(res.getNacta());
		params.add(res.getAnoacta());
		params.add(res.getTerritorio());
//		params.add(res.getVer());
		try {
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "0";
	}
	
	public boolean existeCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		boolean encontrado=false;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bCierreBD.anocierre);
		strSql.append(" FROM ");
		strSql.append(W83bCierreBD.tablacierre);
		strSql.append(" WHERE ");
		strSql.append(W83bCierreBD.anocierre).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bCierreBD.mescierre).append("=?");
		
		params.add(Integer.valueOf(param.getAnocierre()));
		params.add(Integer.valueOf(param.getMes()));
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bCierreMensualBean.class,param.getUsuarioBean(), null);
		if (lista.size()>0){
			encontrado=true;
		}
		return encontrado;		
	}
	
	public java.lang.String procesarCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bCierreBD.tablacierre).append(" (");
		
		strSql.append(W83bCierreBD.anocierre).append(",");
		strSql.append(W83bCierreBD.mescierre).append(",");
		
		if (W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierrealava).append(",").append(W83bCierreBD.fechacierreAraba).append(") VALUES (?,?,?,to_date(?,?))");
		}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierrebizkaia).append(",").append(W83bCierreBD.fechacierreBizkaia).append(") VALUES (?,?,?,to_date(?,?))");
		}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierregipuzkoa).append(",").append(W83bCierreBD.fechacierreGipuzkoa).append(") VALUES (?,?,?,to_date(?,?))");
		}
		params.add(param.getAnocierre());
		params.add(param.getMes());
		params.add(W83bClsConstantes.CONSTANTE_SI);
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		W83bClsTrazas.traza(param.getUsuarioBean(),"Quedando la SQL --> "+ strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());
		
		return "0";		
	}
	
	public java.lang.String deshacerCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{		
		return "0";		
	}
	
	public java.lang.String procesarCierreMod(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ");
		strSql.append(W83bCierreBD.tablacierre);
		strSql.append(" SET ");
		if (W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.fechacierreAraba).append(" = to_date(?,?)");
		}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.fechacierreBizkaia).append(" = to_date(?,?)");
		}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.fechacierreGipuzkoa).append(" = to_date(?,?)");
		}
		strSql.append(", ");
		if (W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierrealava).append("=?");
		}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierrebizkaia).append("=?");
		}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
			strSql.append(W83bCierreBD.cierregipuzkoa).append("=?");
		}
		strSql.append(" WHERE ");
		strSql.append(W83bCierreBD.anocierre).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bCierreBD.mescierre).append("=?");
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		params.add(W83bClsConstantes.CONSTANTE_SI);
		params.add(param.getAnocierre());
		params.add(param.getMes());
		W83bClsTrazas.traza(param.getUsuarioBean(),"Quedando la SQL --> "+ strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());
		
		return "0";		
	}
	
	public java.util.List consultarCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append(W83bCierreBD.anocierre).append(", ");
		strSql.append(W83bCierreBD.mescierre).append(", ");
		strSql.append(W83bCierreBD.cierrealava).append(", ");
		strSql.append(W83bCierreBD.cierrebizkaia).append(", ");
		strSql.append(W83bCierreBD.cierregipuzkoa);
		strSql.append(" FROM ");
	    strSql.append(W83bCierreBD.tablacierre);
	    strSql.append(" WHERE ");
	    strSql.append(W83bCierreBD.anocierre).append("=?");
	    
	    strSql.append(" ORDER BY ").append(W83bCierreBD.mescierre);
	    
	    params.add(Integer.valueOf(param.getAnocierre()));
	    
	    List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bCierreMensualBean.class,param.getUsuarioBean(), param.getIdioma());
	 
	    return lista;
	}
	
	public void inicializarVariablesSindicato(){
		nELA=0;
		nLAB=0;
		nUGT=0;
		nCCOO=0;
		nOtros=0;
		nUSO=0;
		nCUIS=0;
		nCTI=0;
		nCSI=0;
		nNOSIN=0;
	}
	public void inicializarVarExcelDes(){
		nELAdes=0;
		nLABdes=0;
		nUGTdes=0;
		nCCOOdes=0;
		nOtrosdes=0;
		nUSOdes=0;
		nCUISdes=0;
		nCTIdes=0;
		nCSIdes=0;
		nNOSINdes=0;
	}
	public void sumarVarExcelDes(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
			nELAdes=nELAdes+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	nLABdes=nLABdes+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	nUGTdes=nUGTdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	nCCOOdes=nCCOOdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	nUSOdes=nUSOdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	nCUISdes=nCUISdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	nCTIdes=nCTIdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	nCSIdes=nCSIdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	nNOSINdes=nNOSINdes+Integer.parseInt(numdelegados);
	    }else{
	    	nOtrosdes=nOtrosdes+Integer.parseInt(numdelegados);
	    }
	}
	public void restarVarExcelDes(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
			nELAdes=nELAdes-Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	nLABdes=nLABdes-Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	nUGTdes=nUGTdes-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	nCCOOdes=nCCOOdes-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	nUSOdes=nUSOdes-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	nCUISdes=nCUISdes-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	nCTIdes=nCTIdes-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	nCSIdes=nCSIdes-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	nNOSINdes=nNOSINdes-Integer.parseInt(numdelegados);
	    }else{
	    	nOtrosdes=nOtrosdes-Integer.parseInt(numdelegados);
	    }
	}
	public void inicializarVariablesDelegados(){
		numdelegadosELA=0;
	    numdelegadosLAB=0;
	    numdelegadosUGT=0;
	    numdelegadosCCOO=0;
	    numdelegadosOtros=0;
	    numdelegadosUSO=0;
	    numdelegadosCUIS=0;
	    numdelegadosCTI=0;
	    numdelegadosCSI=0;
	    numdelegadosNOSIN=0;
	}
	
	public void inicializarVariablesDelegadosdes(){
		numdelegadosELAdes=0;
	    numdelegadosLABdes=0;
	    numdelegadosUGTdes=0;
	    numdelegadosCCOOdes=0;
	    numdelegadosOtrosdes=0;
	    numdelegadosUSOdes=0;
	    numdelegadosCUISdes=0;
	    numdelegadosCTIdes=0;
	    numdelegadosCSIdes=0;
	    numdelegadosNOSINdes=0;
	}
	
	public W83bCierreMensualBean obtenerObjetoCierre(W83bCierreMensualBean cm){
		cm.setEla(numdelegadosELA);
	    cm.setLab(numdelegadosLAB);
	    cm.setUgt(numdelegadosUGT);
	    cm.setCcoo(numdelegadosCCOO);
	    cm.setOtros(numdelegadosOtros);
	    cm.setUso(numdelegadosUSO);
	    cm.setCuis(numdelegadosCUIS);
	    cm.setCti(numdelegadosCTI);
	    cm.setCsi(numdelegadosCSI);
	    cm.setNosin(numdelegadosNOSIN);
	    cm.setTotaldel(numdelegadosELA+numdelegadosLAB+numdelegadosUGT+numdelegadosCCOO+numdelegadosUSO+numdelegadosCUIS+numdelegadosCTI+numdelegadosCSI+numdelegadosNOSIN+numdelegadosOtros);
	    return cm;
	}
	
	public void sumardelegados(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
    		numdelegadosELA=numdelegadosELA+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	numdelegadosLAB=numdelegadosLAB+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	numdelegadosUGT=numdelegadosUGT+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	numdelegadosCCOO=numdelegadosCCOO+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	numdelegadosUSO=numdelegadosUSO+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	numdelegadosCUIS=numdelegadosCUIS+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	numdelegadosCTI=numdelegadosCTI+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	numdelegadosCSI=numdelegadosCSI+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	numdelegadosNOSIN=numdelegadosNOSIN+Integer.parseInt(numdelegados);
	    }else{
	    	numdelegadosOtros=numdelegadosOtros+Integer.parseInt(numdelegados);
	    }
	}
	public void sumardelegadosexcel(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
			nELA=nELA+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	nLAB=nLAB+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	nUGT=nUGT+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	nCCOO=nCCOO+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	nUSO=nUSO+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	nCUIS=nCUIS+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	nCTI=nCTI+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	nCSI=nCSI+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	nNOSIN=nNOSIN+Integer.parseInt(numdelegados);
	    }else{
	    	nOtros=nOtros+Integer.parseInt(numdelegados);
	    }
	}
	public void sumardelegadosdes(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
			numdelegadosELAdes=numdelegadosELAdes+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	numdelegadosLABdes=numdelegadosLABdes+Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	numdelegadosUGTdes=numdelegadosUGTdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	numdelegadosCCOOdes=numdelegadosCCOOdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	numdelegadosUSOdes=numdelegadosUSOdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	numdelegadosCUISdes=numdelegadosCUISdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	numdelegadosCTIdes=numdelegadosCTIdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	numdelegadosCSIdes=numdelegadosCSIdes+Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	numdelegadosNOSINdes=numdelegadosNOSINdes+Integer.parseInt(numdelegados);
	    }else{
	    	numdelegadosOtrosdes=numdelegadosOtrosdes+Integer.parseInt(numdelegados);
	    }
	}
	public void restardelegadosdes(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
    		numdelegadosELAdes=numdelegadosELAdes-Integer.parseInt(numdelegados);
    		//nELA=nELA-Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	numdelegadosLABdes=numdelegadosLABdes-Integer.parseInt(numdelegados);
	    	//nLAB=nLAB-Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	numdelegadosUGTdes=numdelegadosUGTdes-Integer.parseInt(numdelegados);
	    	//nUGT=nUGT-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	numdelegadosCCOOdes=numdelegadosCCOOdes-Integer.parseInt(numdelegados);
	    	//nCCOO=nCCOO-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	numdelegadosUSOdes=numdelegadosUSOdes-Integer.parseInt(numdelegados);
	    	//nUSO=nUSO-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	numdelegadosCUISdes=numdelegadosCUISdes-Integer.parseInt(numdelegados);
	    	//nCUIS=nCUIS-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	numdelegadosCTIdes=numdelegadosCTIdes-Integer.parseInt(numdelegados);
	    	//nCTI=nCTI-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	numdelegadosCSIdes=numdelegadosCSIdes-Integer.parseInt(numdelegados);
	    	//nCSI=nCSI-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	numdelegadosNOSINdes=numdelegadosNOSINdes-Integer.parseInt(numdelegados);
	    	//nNOSIN=nNOSIN-Integer.parseInt(numdelegados);
	    }else{
	    	numdelegadosOtrosdes=numdelegadosOtrosdes-Integer.parseInt(numdelegados);
	    	//nOtros=nOtros-Integer.parseInt(numdelegados);
	    }
	}
	public void restardelegados(String codsindicato, String numdelegados){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
    		numdelegadosELA=numdelegadosELA-Integer.parseInt(numdelegados);
    		nELA=nELA-Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	numdelegadosLAB=numdelegadosLAB-Integer.parseInt(numdelegados);
	    	nLAB=nLAB-Integer.parseInt(numdelegados);
	    }else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	numdelegadosUGT=numdelegadosUGT-Integer.parseInt(numdelegados);
	    	nUGT=nUGT-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	numdelegadosCCOO=numdelegadosCCOO-Integer.parseInt(numdelegados);
	    	nCCOO=nCCOO-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	numdelegadosUSO=numdelegadosUSO-Integer.parseInt(numdelegados);
	    	nUSO=nUSO-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	numdelegadosCUIS=numdelegadosCUIS-Integer.parseInt(numdelegados);
	    	nCUIS=nCUIS-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	numdelegadosCTI=numdelegadosCTI-Integer.parseInt(numdelegados);
	    	nCTI=nCTI-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	numdelegadosCSI=numdelegadosCSI-Integer.parseInt(numdelegados);
	    	nCSI=nCSI-Integer.parseInt(numdelegados);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	numdelegadosNOSIN=numdelegadosNOSIN-Integer.parseInt(numdelegados);
	    	nNOSIN=nNOSIN-Integer.parseInt(numdelegados);
	    }else{
	    	numdelegadosOtros=numdelegadosOtros-Integer.parseInt(numdelegados);
	    	nOtros=nOtros-Integer.parseInt(numdelegados);
	    }
	}
	public void sumarsindcoincidentes(String codsindicato, String numdelegadosind, String numdelegadosact){
		if (codsindicato.equals(W83bClsConstantes.codELA)){
    		numdelegadosELA=numdelegadosELA+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
    		nELA=nELA+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
		}else if(codsindicato.equals(W83bClsConstantes.codLAB)){
	    	numdelegadosLAB=numdelegadosLAB+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nLAB=nLAB+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
		}else if(codsindicato.equals(W83bClsConstantes.codUGT)){
	    	numdelegadosUGT=numdelegadosUGT+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nUGT=nUGT+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
		}else if (codsindicato.equals(W83bClsConstantes.codCCOO)){
	    	numdelegadosCCOO=numdelegadosCCOO+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nCCOO=nCCOO+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
		}else if (codsindicato.equals(W83bClsConstantes.codUSO)){
	    	numdelegadosUSO=numdelegadosUSO+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nUSO=nUSO+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
		}else if (codsindicato.equals(W83bClsConstantes.codCUIS)){
	    	numdelegadosCUIS=numdelegadosCUIS+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nCUIS=nCUIS+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
		}else if (codsindicato.equals(W83bClsConstantes.codCTI)){
	    	numdelegadosCTI=numdelegadosCTI+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nCTI=nCTI+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    }else if (codsindicato.equals(W83bClsConstantes.codCSI)){
	    	numdelegadosCSI=numdelegadosCSI+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nCSI=nCSI+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    }else if (codsindicato.equals(W83bClsConstantes.codNOSIN)){
	    	numdelegadosNOSIN=numdelegadosNOSIN+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nNOSIN=nNOSIN+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    }else{
	    	numdelegadosOtros=numdelegadosOtros+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    	nOtros=nOtros+Integer.parseInt(numdelegadosind)-Integer.parseInt(numdelegadosact);
	    }
	}
	
	public void anyadirHistorialTramitacionCierre(W83bResultadosBean param,String fase,String tramite,W83bCierreMensualBean cierre) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		
		strSql.append("(");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuario);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),?,?,");
		strSql.append("to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),");
		strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'))");
		
		params.add(new Integer(param.getNacta()));
		params.add(new Integer(param.getAnoacta()));
		params.add(param.getTerritorio());
		params.add(param.getVer());
		params.add(new Integer(tramite));
		params.add(new Integer(fase));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(cierre.getUsuarioBean().getIdUsuario());
		params.add(cierre.getUsuarioBean().getIdUsuario());
		params.add(sdf.format(new Date()));
		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(cierre.getAnocierre()), Integer.parseInt(cierre.getMes())-1, 1);
		int dias=cal.getActualMaximum(Calendar.DAY_OF_MONTH);
		cal.set(Integer.parseInt(cierre.getAnocierre()), Integer.parseInt(cierre.getMes())-1, dias);
		params.add(sdf.format(cal.getTime()));
		W83bDataBase.executeTableMovement(strSql.toString(), params,cierre.getUsuarioBean());		
	}
	
	public java.util.List buscarActascierrehistorial(w83b.w83bBeans.W83bCierreMensualBean param, int dias)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String mes="";
		String anno="";
		List lista = new ArrayList();
		try{
			strSql.append("SELECT "); 
			strSql.append(W83bActasBD.hisTram_numActa).append(", ");
			strSql.append(W83bActasBD.hisTram_anyoActa).append(", ");
			strSql.append(W83bActasBD.hisTram_territActa).append(", ");
			strSql.append(W83bActasBD.hisTram_versionActa);
			strSql.append(" FROM ").append(W83bActasBD.historial_tramitacion_Synonym);
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.hisTram_fase).append("=?");
			params.add(W83bClsConstantes.FASE_CIERRE_MENSUAL);
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_tram).append("=?");
			params.add(W83bClsConstantes.TRAMITE_ACTA_ALTA);
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_territActa).append("=?");
			params.add(param.getTerritorio());
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_fechaTram).append(" BETWEEN TO_DATE('");
			if (Integer.parseInt(param.getMes())==1){
				mes=String.valueOf(W83bClsConstantes.DOCE);
				anno=String.valueOf(Integer.parseInt(param.getAnocierre())-1);
			}
			else{
				mes=String.valueOf(Integer.parseInt(param.getMes())-1);
				anno=String.valueOf(param.getAnocierre());
			}
			strSql.append("1/").append(mes).append("/").append(anno).append(" 00:00:00','").append(W83bDateUtil.ES_PATTERN_HORA_INSERT).append("') AND TO_DATE('").append(dias).append("/").append(mes).append("/").append(anno).append(" 23:59:59','").append(W83bDateUtil.ES_PATTERN_HORA_INSERT).append("') ");
			
			lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bTramiteActaBean.class,param.getUsuarioBean(), "cierre");
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "buscarActascierrehistorial", null);
			throw e;
		}
	    
	    return lista;
	}
	
	public void modificarActascierrehistorial(W83bTramiteActaBean res) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();//NOPMD
		strSql.append("UPDATE ");
		strSql.append(W83bActasBD.tablaActas);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.nueva).append("=0");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=?");
//		strSql.append(" AND ");
//		strSql.append(W83bActasBD.versionActa).append("=?");
		params.add(res.getNumActa());
		params.add(res.getAnyoActa());
		params.add(res.getTerritActa());
//		params.add(res.getVer());
		try {
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		} catch (Exception e) {
			W83bClsTrazas.trazaError(null, "modificarActascierrehistorial", null);
			throw e;
		}
	}
	
	public void borrarActascierrehistorial(java.util.List lista, w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql;//NOPMD
		List params;//NOPMD
		W83bTramiteActaBean acta;
		String mes="";
		String anno="";
		for (int i=0;i<lista.size();i++){
			acta = (W83bTramiteActaBean)lista.get(i);
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
			params = new ArrayList();//NOPMD
			strSql.append("DELETE FROM ");
			strSql.append(W83bActasBD.historial_tramitacion_Synonym);
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.hisTram_numActa);
			strSql.append(" = ? AND ");
			strSql.append(W83bActasBD.hisTram_anyoActa);
			strSql.append(" = ? AND ");
			strSql.append(W83bActasBD.hisTram_territActa);
			strSql.append(" = ? AND ");
			strSql.append(W83bActasBD.hisTram_versionActa);
			strSql.append(" = ? AND ");
			strSql.append(W83bActasBD.hisTram_fase);
			strSql.append(" = ? ");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_tram);
			strSql.append(" = ? ");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_fechaTram).append(" >= TO_DATE('");
			if (Integer.parseInt(param.getMes())==1){
				mes=String.valueOf(W83bClsConstantes.DOCE);
				anno=String.valueOf(Integer.parseInt(param.getAnocierre())-1);
			}
			else{
				mes=String.valueOf(Integer.parseInt(param.getMes())-1);
				anno=String.valueOf(param.getAnocierre());
			}
			strSql.append("1/").append(mes).append("/").append(anno).append("','dd/mm/yyyy') ");
			params.add(acta.getNumActa());		
			params.add(acta.getAnyoActa());
			params.add(acta.getTerritActa());
			params.add(acta.getVersionActa());
			params.add(W83bClsConstantes.FASE_CIERRE_MENSUAL);
			params.add(W83bClsConstantes.TRAMITE_ACTA_ALTA);
			try {
				W83bDataBase.executeTableMovement(strSql.toString(), params, null);
			} catch (Exception e) {
				W83bClsTrazas.trazaError(null, "borrarActascierrehistorial", null);
				throw e;
			}
		}
	}
	
	public void deshacerTablaCierre(w83b.w83bBeans.W83bCierreMensualBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		try{
			strSql.append("UPDATE ");
			strSql.append(W83bCierreBD.tablacierre);
			strSql.append(" SET ");
			if (W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.cierrealava).append("=?");
			}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.cierrebizkaia).append("=?");
			}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.cierregipuzkoa).append("=?");
			}
			strSql.append(", ");
			if (W83bClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.fechacierreAraba).append("=?");
			}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.fechacierreBizkaia).append("=?");
			}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
				strSql.append(W83bCierreBD.fechacierreGipuzkoa).append("=?");
			}
			strSql.append(" WHERE ");
			strSql.append(W83bCierreBD.anocierre).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bCierreBD.mescierre).append("=?");
			params.add(W83bClsConstantes.CONSTANTE_NO);
			params.add(W83bClsConstantes.NULL_DATE);
			if (Integer.parseInt(param.getMes())==1){
				params.add(String.valueOf(Integer.parseInt(param.getAnocierre())-1));
				params.add(String.valueOf(W83bClsConstantes.DOCE));
			}
			else{
				params.add(param.getAnocierre());
				params.add(String.valueOf(Integer.parseInt(param.getMes())-1));
			}
			W83bClsTrazas.traza(param.getUsuarioBean(),"Quedando la SQL --> "+ strSql.toString());
			W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());
		}
		catch (Exception e) {
			W83bClsTrazas.trazaError(null, "deshacerTablaCierre", null);
			throw e;
		}
				
	}
	
	public HashMap calculardelegadossinuevasnoincidencias(HashMap excelultfila, String actanueva, String fecha, W83bUsuarioXLNetsBean usuario) throws Exception{
		inicializarVarExcelDes();
		W83bClsTrazas.trazaError(null, "En calculardelegadossinuevasnoincidencias", null);
		//Calcular incidencias con fecha de validacin posteriores a la que se mira
		List delegadosversmax=calculardelegadosaversionmaxima(actanueva,fecha,usuario);
		W83bClsTrazas.trazaError(null, "delegadosversmax="+delegadosversmax.size(), null);
		List delegadosverscero=calculardelegadosversioncero(actanueva,usuario);
		W83bClsTrazas.trazaError(null, "delegadosverscero="+delegadosverscero.size(), null);
		
		HashMap delegversmax=new HashMap();
		HashMap delegverscero=new HashMap();
		for (int i=0; i<delegadosversmax.size();i++){
			W83bDelegadosBean delegados = (W83bDelegadosBean)delegadosversmax.get(i);
			delegversmax.put(delegados.getCodSindicato(), delegados.getNumdelegados());
		}
		for (int i=0; i<delegadosverscero.size();i++){
			W83bDelegadosBean delegados = (W83bDelegadosBean)delegadosverscero.get(i);
			delegverscero.put(delegados.getCodSindicato(), delegados.getNumdelegados());
		}
		W83bClsTrazas.trazaError(null, "delegversmax="+delegadosversmax.size(), null);
		W83bClsTrazas.trazaError(null, "delegverscero="+delegverscero.size(), null);
		Iterator maxdel = delegversmax.entrySet().iterator();
		//incidencias de sustitucin... y subsanacin(se aaden delegados)
		while (maxdel.hasNext()) {
			W83bClsTrazas.trazaError(null, "entrado en maxdel=", null);
			Map.Entry md = (Map.Entry)maxdel.next();
			int numdelmax=0;
			int numdelcero=0;
			W83bClsTrazas.trazaError(null, "delegverscero.get((String)md.getKey())="+delegverscero.get((String)md.getKey()), null);
			if (delegverscero.get((String)md.getKey())!=null){
				W83bClsTrazas.trazaError(null, "distinto de nulo=", null);
				//Est en versiones posteriores y en la 0
				numdelmax=Integer.parseInt((String)md.getValue());
				numdelcero=Integer.parseInt((String)delegverscero.get((String)md.getKey()));
				W83bClsTrazas.trazaError(null, "numdelmax="+numdelmax, null);
				W83bClsTrazas.trazaError(null, "numdelcero="+numdelcero, null);
				//Si el nmero de delegados es el mismo se deja como est
				//Si no es el mismo se restan los de la versin superior a la cero
				W83bClsTrazas.trazaError(null, "numdelmax distinto numdelcero?="+numdelcero, null);
				if (numdelmax!=numdelcero){
					W83bClsTrazas.trazaError(null, "distinto=", null);
					sumardelegadosdes((String)md.getKey(),String.valueOf(numdelcero-numdelmax));
					sumarVarExcelDes((String)md.getKey(),String.valueOf(numdelcero-numdelmax));
				}
			}
			else{
				W83bClsTrazas.trazaError(null, "es nulo=", null);
				//Si est en la versin mxima, pero no en la cero se resta
				restardelegadosdes((String)md.getKey(),(String)md.getValue());
				restarVarExcelDes((String)md.getKey(),(String)md.getValue());
			}
		}
		//incidencias de baja, si est en la versin cero pero no en la mxima
		Iterator cerodel = delegverscero.entrySet().iterator();
		List inc=calcularnuminci(actanueva,usuario);
		while (cerodel.hasNext()) {
			W83bClsTrazas.trazaError(null, "entrado=", null);
			Map.Entry cd = (Map.Entry)cerodel.next();
			if (delegversmax.get((String)cd.getKey())==null && inc.size()>0){
				W83bClsTrazas.trazaError(null, "entrado2=", null);
				sumardelegadosdes((String)cd.getKey(),String.valueOf((String)cd.getValue()));
				sumarVarExcelDes((String)cd.getKey(),String.valueOf((String)cd.getValue()));
			}

		}
		W83bCierreMensualBean cm = new W83bCierreMensualBean();
		cm.setEla(nELAdes);
	    cm.setLab(nLABdes);
	    cm.setUgt(nUGTdes);
	    cm.setCcoo(nCCOOdes);
	    cm.setOtros(nOtrosdes);
	    cm.setUso(nUSOdes);
	    cm.setCuis(nCUISdes);
	    cm.setCti(nCTIdes);
	    cm.setCsi(nCSIdes);
	    cm.setNosin(nNOSINdes);
	    
	    excelultfila.put(actanueva, cm);
	    
	    return excelultfila;
	}
	
	
	public java.util.List calculardelegadosaversionmaxima(String actanueva, String fecha, W83bUsuarioXLNetsBean usuario)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String[] valores=actanueva.split("\\|");
		List lista = new ArrayList();
		try{
			strSql.append("SELECT "); 
			strSql.append(W83bDelegadosBD.codSindicato).append(", ");
			strSql.append("COUNT(*)").append(" AS ").append(W83bDelegadosBD.numdelegados);
			strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);
			strSql.append(" WHERE ");
			strSql.append(W83bDelegadosBD.acta).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.anyoActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.territorioActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.fechaBaja).append(" IS NULL");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.versionActa).append("=(");
			strSql.append("SELECT ");
			strSql.append("MAX(");
			strSql.append(W83bIncidenciasBD.VERSION_ACTA_061);
			strSql.append(")");
			strSql.append(" FROM ");
			strSql.append(W83bIncidenciasBD.incidenciasSinonimo);
			strSql.append(" WHERE ");
			strSql.append(W83bIncidenciasBD.N_ACTA_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.ANO_ACTA_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.C_TERRIT_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.F_VALIDAC_061).append(">").append("TO_DATE(?,'dd/MM/yyyy') ");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.VALIDADA_061).append("=1)");
			
			strSql.append(" GROUP BY ");
			strSql.append(W83bDelegadosBD.codSindicato);

			params.add(valores[2]);
			params.add(valores[1]);
			params.add(valores[0]);
			params.add(valores[2]);
			params.add(valores[1]);
			params.add(valores[0]);
			params.add(fecha);
			
			
			lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadosBean.class,usuario, "calculodelegados");
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "calculardelegadosaversionmaxima", null);
			throw e;
		}
	    
	    return lista;
	}
	
	public java.util.List calculardelegadosversioncero(String actanueva, W83bUsuarioXLNetsBean usuario)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String[] valores=actanueva.split("\\|");
		List lista = new ArrayList();
		try{
			strSql.append("SELECT "); 
			strSql.append(W83bDelegadosBD.codSindicato).append(", ");
			strSql.append("COUNT(*)").append(" AS ").append(W83bDelegadosBD.numdelegados);
			strSql.append(" FROM ");
			strSql.append(W83bDelegadosBD.delegadosVista);
			strSql.append(" WHERE ");
			strSql.append(W83bDelegadosBD.acta).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.anyoActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.territorioActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.versionActa).append("=0");
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.fechaBaja).append(" IS NULL");

			params.add(valores[2]);
			params.add(valores[1]);
			params.add(valores[0]);
			
			strSql.append(" GROUP BY ");
			strSql.append(W83bDelegadosBD.codSindicato);
			
			lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadosBean.class,usuario, "calculodelegados");
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "calculardelegadosaversioncero", null);
			throw e;
		}
	    
	    return lista;
	}
	
	public java.util.List calcularnuminci(String actanueva, W83bUsuarioXLNetsBean usuario)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String[] valores=actanueva.split("\\|");
		List lista = new ArrayList();
		try{
			strSql.append("SELECT "); 
			strSql.append(W83bIncidenciasBD.N_ACTA_061).append(" AS ").append(W83bIncidenciasVistaBD.numacta);
			strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
			strSql.append(" WHERE ");
			strSql.append(W83bIncidenciasBD.N_ACTA_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.ANO_ACTA_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.C_TERRIT_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.VALIDADA_061).append("=1");

			params.add(valores[2]);
			params.add(valores[1]);
			params.add(valores[0]);
			
			lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bIncidenciasBean.class,usuario, "calcularnuminci");
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "calcularnuminci", null);
			throw e;
		}
	    
	    return lista;
	}
}